import { Fragment } from 'react';
import ReactDOM from 'react-dom';
import { domElements } from '../constants/selectors';
import { IframeErrorPage } from './IframeErrorPage';
import useAppEmbedder from '../utils/useAppEmbedder';

export const IframePortal = (props: React.PropsWithChildren) => {
  const container = document.getElementById(domElements.leadinIframeContainer);
  const iframeNotRendered = useAppEmbedder('integrated-form-app', container);

  if (container && !iframeNotRendered) {
    return ReactDOM.createPortal(props.children, container);
  }

  return (
    <Fragment>
      {(!container || iframeNotRendered) && <IframeErrorPage />}
    </Fragment>
  );
};

export const renderIframeApp = () => {
  const iframeFallbackContainer = document.getElementById(
    domElements.leadinIframeFallbackContainer
  );
  ReactDOM.render(<IframePortal />, iframeFallbackContainer);
};
